      program geh_main
c     ****************************************************************
c     * Program to fit one (or two) calculated energy release profiles,
c     * added and covolved with an experimental function, to observed
c     * energy release data. Attempt to fit it to one
c     ****************************************************************

      implicit real(a-h,o-z)

      real phi,m1,m2,E0,W1,W2,beta,corner(4),minchi2,labmin
      real vertix(5,4),labprob(1000),labenergy(1000),labmax
      real profprob(1000),ftol,phi2,bestW1,bestW2,bestbeta
      real theresult(6),chi2,calcenergy(1000),pcalcprob(1000)
      real fact2,w1cm
      character*99 outfile,input,labinput
      character*20 charE0,charW1,charW2,charbeta,charchi2
      integer i,j,k,iphi,labpoints,iter,profpoints
      common /one/ bestW1,bestW2,bestbeta,bestE0,minchi2
      common/two/ labprob,E0,labenergy,labmax,labmin,fact2
      common /three/ labpoints,profpoints,profprob,pcalcprob

c     ***************************************
c     * Entering initial values for the fit *
c     ***************************************

 1     format (a)
       write (6,*)' '
       write (6,*)'Please enter the E0 value (eV)'
       read (5,*)E0
       write (6,*)' '
       write (6,*)'Please enter an initial guess at width 1 (eV)'
       read (5,*)W1
       write (6,*)' '
C       write (6,*)'Please enter an initial guess at width 2 (eV)'
C       read (5,*)W2
       W2=0.0
       write (6,*)' '
C       write (6,*)'Please enter initial factor Inten2/Inten1'
C       read (5,*)fact2
       fact2=0.0
       write (6,*)' '
       write (6,*)'Please enter the beta value'
       read (5,*)beta
       write (6,*)' '
       write (6,*)'The instrumental profile filename is intrin4'
c       read (5,1)input
       input='newintrin_red'
       write (6,*)' '
       write (6,*)'Please enter the lab data filename'
       read (5,1) labinput
       write (6,*)' '
       write (6,*)'Please enter an initial change in E0 (%)'
       read (5,*)E0c
       write (6,*)' '
       write (6,*)'Please enter an initial change in W1 (%)'
       read (5,*)W1c
       write (6,*)' '
C       write (6,*)'Please enter an initial change in W2 (%)'
C       read (5,*)W2c
       W2c=0.0
       write (6,*)' '
       write (6,*)'Please enter an initial change in beta (%)'
       read (5,*)betac
       write (6,*)' '
       write (6,*)'Please enter the tolerance level'
       read (5,*)ftol
       write (6,*)' '
       write (6,*)'Thanks.'
       
c       open (unit=7,file='output',status='unknown')

c     ****************************************************************
c     * Read in experimental data and intrinsic profile data
c     ****************************************************************
       open (unit=20,file=labinput,status='old')
       do i=1,1000
          read (20,*,end=10)labenergy(i),labprob(i)
C          labenergy(i)=labenergy(i)*2
C          write(10,*)labenergy(i),labprob(i)
C Finds the maximum of the peak
          if (labprob(i).gt.labmax) then
             labmax = labprob(i)
          end if
C          write(10,*)i,labmax          
      end do
 10    close (unit=20)
       labmin=labprob(1)
       labpoints = i - 1
       
       open (unit=25,file=input,status='old')

       do i=1,500
          read (25,*,end=11)profprob(i)
c          write (6,*)profprob(i)
       end do
 11    close (unit=25)
       profpoints=i-1

       write (6,*)'Initial E0 is ',E0
       write (6,*)'Initial W1 is ',W1
C       write (6,*)'Initial W2 is ',W2
       write (6,*)'Initial beta is ',beta
C       write (6,*)'Factor is ',fact2
c       write (6,*)'no. of profile points ',profpoints
c       write (6,*)'labmin=',labmin
       minchi2 = 1.0e38
       
c     ****************************************************************
c     * Plot origonal data for graphical comparison
c     ****************************************************************
	call pgbeg(0,'/xwindow',1,1)
	call pgslw(2)
	call pgsci(1)
	call pgsch(1.5)
	call pgscf(2)
	call pgenv((7.22e-21),(7.28e-21),(2e-23),(labmax + (labmax/100)),
     &  0,0)
	call pglabel('Momentum(kgm/s)','Probability',' ')
	call pgscf(1)
	call pgsci(1)
	call pgpoint(labpoints,labenergy,labprob,1)



c     **********************************
c     * Setting up vertices for amoeba *
c     **********************************

       W1c = (W1c / 100) * W1
       W2c = (W2c / 100) * W2
       betac = (betac / 100) * beta
       E0c = (E0c / 100) * E0
       W1c = W1 + W1c
       W2c = W2 + W2c
       betac = beta + betac
       E0c = E0 + E0c

c     ****************************************************************
c     * corner(1) = W1
c     * corner(2) = W2
c     * corner(3) = beta
c     * corner(4) = E0
c     ****************************************************************
       do i=1,5
          vertix(i,1) = W1
          vertix(i,2) = W2
          vertix(i,3) = beta
          vertix(i,4) = E0
       end do

       vertix(2,1) = W1c
       vertix(3,2) = W2c
       vertix(4,3) = betac
       vertix(5,4) = E0c

       do i=1,5
          do k=1,4
             corner(k) = vertix(i,k)
          end do
          theresult(i) = phi2(corner)
          write (6,*)'Chi^2 is ',theresult(i)
       end do

       write (6,*)' '
       write (6,*)'Finished initializing, calling amoeba...'

       call amoeba(vertix,theresult,5,4,4,ftol,phi2,iter)

       do i=1,5
          vertix(i,1) = bestW1
          vertix(i,2) = bestW2
          vertix(i,3) = bestbeta
          vertix(i,4) = bestE0
       end do
       
       vertix(2,1) = W1c - (W1c / 10)
       vertix(3,2) = W2c - (W2c / 12)
       vertix(4,3) = betac - (betac / 15)
       vertix(5,4) = E0c - (E0c /500)

       write (6,*)' '
       write (6,*)'Initializing again'
       write (6,*)' '

       do i=1,5
          do k=1,4
             corner(k)= vertix(i,k)
          end do
          theresult(i) = phi2(corner)
          write (6,*)'Chi^2 is ',theresult(i)
       end do

       write (6,*)' '
       write (6,*)'Finished initializing, calling amoeba...'

       call amoeba(vertix,theresult,5,4,4,ftol,phi2,iter)

       write (6,*)' '
       write (6,*)'Best W1 is ',bestW1
       write (6,*)'Best W1 is ',bestW1*8065.54

C       write (6,*)'Best W2 is ',bestW2
       write (6,*)'Best beta is ',bestbeta
       write (6,*)'Best E0 is ',bestE0
       write (6,*)' '
       write (charW1,*)bestW1
       write (charW2,*)bestW2
       write (charbeta,*)bestbeta
       write (charE0,*)bestE0
       write (charchi2,*)minchi2
       w1cm=bestW1*8065.54
c     ****************************************************************
c     * Plot parameters determined in fit on graph ready for printing
c     ****************************************************************
	call pgsci(1)
	call pgpoint(labpoints,labenergy,labprob,1)
        call pgsch(.75)
        call pgtext(7.22e-21,labmax-200,'bestW1=')
        call pgtext(7.27e-21,labmax-200,'bestW1(cm^-1)=')

C        call pgtext(7.26e-21,labmax-300,'bestW2=')
        call pgtext(7.22e-21,labmax-400,'bestbeta=')
        call pgtext(7.22e-21,labmax-500,'bestE0=')
        call pgtext(7.22e-21,labmax-600,'bestchi^2=')
        call pgtext(7.22e-21,labmax-100,labinput)
        call pgtext(7.225e-21,labmax-200,charW1)
        call pgtext(7.275e-21,labmax-200,charw1cm)


C        call pgtext(220.2,labmax-300,charW2)
        call pgtext(7.225e-21,labmax-400,charbeta)
        call pgtext(7.225e-21,labmax-500,charE0)
        call pgtext(7.225e-21,labmax-600,charchi2)
        pause
        call pgend

       end






        function phi2(corner)
c     ****************************************************************
c     * The profiles are calculated, added, convolved and compared with
c     * the experimental data within this routine or below it
c     ****************************************************************

        implicit real(a-h,o-z)

	integer iphi,i,profpoints,labpoints
	real phi,m1,m2,corner(4),calcenergy1(1000),calcprob(1000),beta
        real calcenergy2(1000),rcalcprob1(1000),rcalcprob2(1000)
        real tcalcprob(1000),empty(1000),labenergy(1000),labprob(1000)
        real ccalcprob(1000),ncalcprob(1000),pcalcprob(1000)
        common /one/ bestW1,bestW2,bestbeta,bestE0,minchi2
        common /two/ labprob,E0,labenergy,labmax,labmin,fact2
        common /three/ labpoints,profpoints,profprob,pcalcprob

	m1=69.92425
	m2=1.007825
        amu=1.67353e-27
        evolt=1.60217733e-19
        do i=1,labpoints
           empty(i)=0.0
        end do

c     ****************************************************************
c     * Calculate profiles.
c     ****************************************************************

	do iphi=0,180
	phi=real(iphi-180)*3.14159/180.0
	  calcprob(iphi)=(1.0/(2*3.14159))*(1.0+corner(3)*0.5*
     *		(3.0*cos(1.5708-phi)*cos(1.5708-phi)-1.0))
C	  calcenergy1(iphi)=(m1*m2/(m1+m2))*(corner(4)/m2+2.0*sqrt(E0*
C     &         corner(1)/(m1*m2))*cos(phi)+corner(1)/m1)/15

	  calcenergy1(iphi)=sqrt(evolt*2*m1*amu*((m1*m2/(m1+m2))*
     &     (corner(4)/m2+(2.0*(sqrt(E0*
     &         corner(1)/(m1*m2))))*cos(phi)+corner(1)/m1)))
C          write(8,*)'calcenergy(iphi)=',calcenergy1(iphi)
	  if (corner(2).ne.0.0) then 
             calcenergy2(iphi)=(m1*m2/(m1+m2))*(corner(4)/m2+2.0*sqrt
     &            (E0*corner(2)/(m1*m2))*cos(phi)+corner(2)/m1)/15
          endif
C        write(9,*)calcprob(iphi),calcenergy1(iphi)
	end do
       call rebin(calcprob,calcenergy1,rcalcprob1,labenergy,
     &       labpoints)
        if (corner(2).ne.0.0) then 
           call rebin(calcprob,calcenergy2,rcalcprob2,labenergy,
     &       labpoints)
        endif
c          write(6,*)'Re-binned'
        if (corner(2).eq.0) then
           call profadd(tcalcprob,rcalcprob1,empty,labpoints,0)
           else
              call profadd(tcalcprob,rcalcprob1,rcalcprob2,labpoints,
     &             fact2)
        endif
c      write(6,*)'Added profiles'
        call convolve(tcalcprob,ccalcprob,labenergy,profprob,
     &       labpoints,profpoints)
c        write(6,*)'Convolved with intrinsic profile'
	call pgsci(0)
	call pgpoint(labpoints,labenergy,ncalcprob,0901)
        call normalise(ccalcprob,ncalcprob,labpoints,labmax,labmin)
	call pgsci(14)
	call pgpoint(labpoints,labenergy,ncalcprob,0901)
        phi2=chi2(ncalcprob,corner)
	end



        subroutine rebin(calcprob,calcenergy,rcalcprob,labenergy,
     &       labpoints)

c     *****************************************************************
c     * Change the energy data set to match that of the experimental data
c     *****************************************************************
        
        real calcprob(1000),labenergy(1000),calcenergy(1000)
        real rcalcprob(1000),dy
        integer labpoints,i,j
        
        do i=1,labpoints
           j=labenergy(i)-7.25e-21/180
           call hunt(calcenergy,180,labenergy(i),j)
           if ((j.eq.0).or.(j.eq.180)) then
              rcalcprob(i)=0.0
              else
              k=min(max(j-3/2,1),177)
C          write(10,*)i,j,k,labenergy(i),calcenergy(j),calcenergy(j+1)
           call polint(calcenergy(k),calcprob(k),4,labenergy(i),
     &          rcalcprob(i),dy)
           endif
           end do
           end

        subroutine profadd(tcalcprob,rcalcprob1,rcalcprob2,
     &          labpoints,fact2)

c     ****************************************************************
c     * Add the profiles together according to the factor fact2
c     ****************************************************************
        
        real tcalcprob(1000),rcalcprob1(1000),rcalcprob2(1000),fact2
        integer labpoints,i

        do i=1,labpoints
           tcalcprob(i)=rcalcprob1(i)+(fact2*rcalcprob2(i))
           end do
        end





      subroutine convolve(tcalcprob,ccalcprob,labenergy,profprob,
     &       labpoints,profpoints)

c     ****************************************************************
c     * Convolve the added calculated profiles with the instrument function
c     ****************************************************************

      implicit real(a-h,o-z)

      real tcalcprob(1000),labenergy(1000),profprob(1000)
      real ccalcprob(1000),ans(2200)
      integer i,j,k,labpoints,profpoints

      do i=labpoints+1,1024
         tcalcprob(i)=0
      end do
      call convlv(tcalcprob,1024,profprob,profpoints,1,ans)
      do j=1,labpoints
         ccalcprob(j)=ans(j)
      end do
        do i=1,labpoints
        end do
        do i=1,profpoints
           end do

      end
       
      subroutine normalise(ccalcprob,ncalcprob,labpoints,labmax,
     &     labmin)

c     ****************************************************************
c     * Normalise the calculated curve to the maximum of the observed data
c     ****************************************************************

      real ccalcprob(1000),ncalcprob(1000),labmax,calcmax,labmin
      integer labpoints,i

      calcmax=0.0
      do i=1,labpoints
         if (calcmax.lt.ccalcprob(i)) then
            calcmax=ccalcprob(i)
         endif
      end do
      
      do i=1,labpoints
         ncalcprob(i)=(ccalcprob(i)*(labmax-labmin)/calcmax)
     &        +labmin
      end do

      end

      function chi2(ncalcprob,corner)

c     ****************************************************************
c     * Calculate a chi^2 for the fit of the calculated and observed
c     * profiles.
c     ****************************************************************

      implicit real(a-h,o-z)

      real labprob(1000),inside,minchi2,ncalcprob(1000)
      real bestW1,bestW2,bestbeta,chi2,corner(4),bestfact2
      integer labpoints
      common /one/ bestW1,bestW2,bestbeta,bestE0,minchi2
      common /two/ labprob,E0,labenergy,labmax,labmin,fact2
      common /three/ labpoints,profpoints,profprob,pcalcprob

      chi2 = 0.
      inside = 0.
      chi2total = 0.

      do i=1,labpoints
         inside = (labprob(i) - ncalcprob(i)) / (labpoints - 3)
         inside = inside * inside
         chi2total = chi2total + inside
      end do

      chi2 = chi2total
      if (chi2total.lt.minchi2) then
         minchi2=chi2total
         bestW1=corner(1)
         bestW2=corner(2)
         bestbeta=corner(3)
         bestE0=corner(4)
      endif

      write(7,*)bestW1,bestW2,bestbeta,bestE0,chi2total,minchi2

      end

















