      SUBROUTINE REFINE2(M,N,W,Y,C,IC,CH,MU,CN,Y1,Y2,IP)
C
C*   M=NO. OF PARAMETERS               W(N)=WEIGHTS OF OBSERVATIONS
C*   N=NO. OF OBSERVATIONS             Y(N)=OBSERVED VALUES
C*   MU=POSN. OF 1st E.S. PARAMETER    CH(M)=NAMES OF PARAMETERS
C*   C(M)=INITIAL VALUES OF PARAMETERS IC(M)='WEIGHTS' OF PARAMETERS
C*      ON EXIT: CN(M) CONTAINS NEW VALUES OF PARAMETERS
C*               Y1(N) CONTAINS INITIAL CALCULATED VALUES
C*               Y2(N) CONTAINS FINAL CALCULATED VALUES
C
      DIMENSION W(N),Y(N),Y1(N),Y2(N),C(M),CN(M),IC(M),Z(20,400),
     &CV(21,20),VCV(21,20),CS(20),COF(20),II(20)
      CHARACTER*5 CH(M)
      SUM=0.0
      SFAC=1.0
      NN=N
      DO 1010 I=1,N
      Y1(I)=0.0
1010  Y2(I)=0.0
      DO 1020 I=1,M
      CS(I)=0.0
      COF(I)=0.0
      II(I)=0
1020  CN(I)=C(I)
      CALL MATZ(Z,20,400)
      CALL MATZ(CV,21,20)
      CALL MATZ(VCV,21,20)
      CHECK=0.0
      IJ=0
      WRITE(26,6001)
      DO 1040 I=1,M
      IF(IC(I).EQ.0)GOTO 1030
      IF(ABS(C(I)).LT.1E-12)THEN
      WRITE(26,6013) I,CH(I)
      IC(I)=0
      GOTO 1030
      ELSE
      IJ=IJ+1
      II(IJ)=I
      END IF
1030  IF(I.NE.MU) GOTO 1040
      WRITE(26,6002)
1040  WRITE(26,6003) CH(I),C(I)
      CALL VALUES(C,M,Y1,N)
      IF(IJ.LT.1)THEN
      WRITE(26,6019)
      RETURN
      END IF
      DO 1050 I=1,IJ
      J=II(I)
      C(J)=C(J)*1.00001
      CALL VALUES(C,M,Y2,N)
      C(J)=C(J)/1.00001
      DO 1050 K=1,N
1050  Z(I,K)=(Y2(K)-Y1(K))*SFAC*100000.0/C(J)
      SUMCH=0.0
      DO 1060 I=1,N
      Y(I)=Y(I)-Y1(I)
1060  SUMCH=SUMCH+ABS(Y(I))
      IF(SUMCH.LT.1.0E-9)GOTO 1210
      NTT=N
      DO 1061 I=1,N
1061  IF(W(I).LT.0.1E-03)NTT=NTT-1
      IF(NTT.LT.IJ)GOTO 1220
      IF(NTT.GT.IJ) GOTO 1062
      WRITE(26,6016)
1062  CONTINUE
      CALL ORTHO(N,IJ,Y,Z,W,COF,CS,VCV,CV,CHECK)
      IF(CHECK.LT.0.0)GOTO 1100
      WRITE(26,6004)
      J=0
      DO 1080 I=1,M
      IF(I.NE.MU) GOTO 1065
      WRITE(26,6002)
1065  IF(IC(I).EQ.0) GOTO 1070
      J=J+1
      CN(I)=C(I)+COF(J)
      CPER=ABS(CS(J)*100.0/CN(I))
      WRITE(26,6005)CH(I),C(I),CN(I),COF(J),CS(J),CPER
      GOTO 1080
1070  WRITE(26,6006) CH(I),C(I)
1080  CONTINUE
      CALL VALUES(CN,M,Y2,N)
      GOTO 1110
1100  WRITE(26,6007) CHECK
      IF(CHECK.EQ.-5)THEN
      WRITE(26,6018)
      IP=3
      END IF
1110  DO 1120 I=1,N
      IF(W(I).LT.0.1)NN=NN-1
      Y(I)=Y(I)+Y1(I)
1120  SUM=SUM+(Y2(I)-Y(I))**2*W(I)
      MM=0
      DO 1122 I=1,M
1122  MM=MM+IC(I)
      NNN=NN-MM
      IF(NNN.LT.1)NNN=1
      SUM=SQRT(SUM)/NNN
      WRITE(26,6008) NN,MM,SUM
      DO 1125 JJJ=2,IJ
      DO 1125 KKK=1,JJJ-1
      IF(ABS(CV(JJJ,KKK)).LT.0.999)GOTO 1125
      WRITE(26,6017)
      IP=3
1125  CONTINUE
      IP=IP+1
      GOTO(1160,1150,1140,1130),IP
1130  WRITE(26,6011)
      CALL PRINTMAT(VCV,IJ,II,CH,M)
1140  WRITE(26,6010)
C     CALL ZPRINT(Z,IJ,N)
1150  WRITE(26,6012)
      CALL PRINTMAT(CV,IJ,II,CH,M)
1160  WRITE(26,6009)
      IP=IP-1
      RETURN
1210  WRITE(26,6015)
      RETURN
1220  WRITE(26,6014)
      RETURN
6001  FORMAT(' INITIAL VALUES OF PARAMETERS',/,' GROUND STATE:',/)
6002  FORMAT(' EXCITED STATE:',/)
6003  FORMAT(' ',15X,1A5,3X,E14.7,/)
6004  FORMAT(' LEAST SQUARES FITTING COMPLETED',/,'1',15X,'PARAMETER'
     &,7X,'OLD VALUE',7X,'NEW VALUE',7X,'DIFFERENCE',6X,'STANDARD DEV.'
     &,5X,'PERCENTAGE ERROR',/,/,'  GROUND STATE:',/)
6005  FORMAT(' ',15X,1A5,10X,4(E14.7,2X),F12.4,'%',/)
6006  FORMAT(' ',15X,1A5,10X,E14.7,10X,'PARAMETER HELD CONSTANT',/)
6007  FORMAT('1FAILURE IN ORTHO: CHECK=',F5.1)
6008  FORMAT('1STANDARD DEVIATION OVER ',I4,' READINGS, ',
     &'FITTING ',I4,' PARAMETERS, IS ',E14.6)
6009  FORMAT('1FITTING SUBROUTINE COMPLETED',/,'1')
6010  FORMAT('1JACOBIAN MATRIX OF DERIVATIVES IS :',/,/)
6011  FORMAT('1VARIANCE-COVARIANCE MATRIX IS:',/,/)
6012  FORMAT('1CORRELATION MATRIX IS:',/,/)
6013  FORMAT(25X,'PARAMETER NUMBER ',I4,' (',1A5,') REMOVED FROM FIT ',
     &':- TOO SMALL',/)
6014  FORMAT(' ERROR:   INSUFFICIENT DATA FOR NUMBER OF PARAMETERS')
6015  FORMAT(' ERROR:  WEIGHTED OBSERVATIONS ALREADY FIT PERFECTLY-',
     &'DATA PROBLEM?')
6016  FORMAT(' WARNING:SAME NUMBER OF DATA POINTS AS PARAMETERS!!')
6017  FORMAT(' WARNING:STRONG CORRELATION BETWEEN SOME PARAMETERS',
     &':- FULL DIAGNOSTICS FOLLOW.',/)
6018  FORMAT(' ZERO DIVIDE IN ORTHO, PROBABLY TRYING TO FIT INVARIATE
     &ITEM.')
6019  FORMAT(' NO PARAMETERS TO BE FITTED:-EXITING REFINE')
      END
                        
                                       
      SUBROUTINE ORTHO(NZ,MZ,Y,Z,W,COF,CS,VCV,CV,CHECK)
C     LINEAR LEAST SQUARES ROUTINE
C     21 PARAMETERS,400 DATA POINTS ALLOWED
C
C     INPUT : OBSERVATIONS ( Y ) .  WEIGHTS OF EACH ( W ) .  MATRIX OF
C DERIVATIVES( Z ).NZ=NO,OF OBSERVATIONS: MZ=NO. OF PARAMETERS.
C OUTPUT : BEST FIT PARAMETERS COF(I),THEIR STD DEVS.,CS(I).STANDARD
C DEVIATION OF AN OBSERVATION OF UNIT WEIGHT(STD), VARIANCE-COVARIANCE 
C MATRIX,
C (VCV,TOP 12 ROWS)
C CV CONTAINS THE CORRELATION MATRIX
C
      DIMENSION Z(20,NZ),Y(NZ),W(NZ),CS(MZ),DEV(400),
     1 COF(MZ),VCV(21,20),A(21,21),CV(21,20)
      DIMENSION X(22,400),GF(200),ENF(200),Q(200),Q2(200),E(200),EP(200
     1),PK(400),QK(200),XP(400)
      N=NZ
      M=MZ
      NP=M
      NR=1
      NZEI=1
      NPP=N+NP
      NPM=N+M
      M1=M-1
      N2=N+1
      M2=M+1
      NRBAR=NR
      NP2=NP+1
      FN=N*1.0D0
      FM=M*1.0D0
      IF (N-M) 200,10,11
10    DENOM=1.0D0
      GO TO 12
11    DENOM=SQRT(FN-FM)
12    NBEI=1
      NRHI=1
      I18=1
      IF (NP) 212,210,212
210   NGAI=1
      NSII=1
      GO TO 16
212   NGAI=2
      NSII=2
16    DO 17 I=1,M
      DO 17 J=1,N
17    X(I,J)=Z(I,J)
      IF(NP) 200,30,22
22    DO 24 I=1,M
      DO 23 J=N2,NPP
23    X(I,J)=0.0D0
      NI=N+I
24    X(I,NI)=1.0D0
30    NDEI=1
      NNUI=1
      LZ1=1
      LZ2=1
      K=1
31    NTHI=1
32    NALI=1
      NOMI=1
      IF(NP) 200,42,33
33    DO 34 J=1,NP
      NJ=N+J
34    PK(NJ)=0.0D0
42    DO 45 I=1,N
   45 PK(I)=X(K,I)*W(I)
      GO TO (51,52),NOMI
51    DO 54 I=1,K
      SUM=0.0D0
      DO 53 J=1,NPP
53    SUM=SUM+PK(J)*X(I,J)
54    QK(I)=SUM
      GO TO 60
52    DK2=0.0D0
      DO 55 I=1,NPP
55    DK2=DK2+PK(I)*X(K,I)
      DK=SQRT(DK2)
      GF(I18)=DK
      I18=I18+1
      IF(ABS(DK).LT.1.0E-25)THEN
      CHECK=-5
      RETURN
      END IF
      DO 56 I=1,NPP
56    X(K,I)=X(K,I)/DK
      NOMI=1
      GO TO 42
60    GO TO (61,62),NDEI
61    LZ1=-LZ1
      IF (LZ1) 67,200,63
63    K1=K-1
      IF (K1) 641,641,631
631   DO 64 I=1,K1
64    QK(I)=-QK(I)
641   QK(K)=1.0D0
      DO 66 I=1,NPP
      SUM=0.0D0
      DO 65 J=1,K
65    SUM=SUM+X(J,I)*QK(J)
66    XP(I)=SUM
      GO TO 70
67    ENF(I18)=SQRT(QK(K))
      GO TO 63
62    LZ2=-LZ2
      IF (LZ2) 68,200,63
68    DO 69 I=1,M
      Q2(I)=QK(I)*QK(I)
   69 Q(I)=QK(I)
      Q(M2)=QK(M2)
      E(1)=Q(M2)-Q2(1)
      DO 691 J=2,M
      J1=J-1
  691 E(J)=E(J1)-Q2(J)
      FI=1.0D0
      DO 697 I=1,M
      IF (FN-FI) 693,693,694
  694 IF(E(I)) 695,696,696
  695 EP(I)=-SQRT(ABS(E(I))/(FN-FI))
      GO TO 697
  696 EP(I)=SQRT(E(I)/(FN-FI))
      GO TO 697
  693 E(I)=-1.0D0
697   FI=FI+1.0D0
      GO TO 63
70    GO TO (71,72,73),NTHI
71    DO 74 I=1,NPP
74    X(K,I)=XP(I)
      GO TO 80
72    DO 75 I=1,N
   75 DEV(I)=XP(I)
      DO 76 I=1,NP
      NI=N+I
   76 COF(I)=-XP(NI)
      NTHI=3
      GO TO 71
73    GO TO 90
80    GO TO (81,83),NALI
81    NOMI=2
      NALI=2
      GO TO 42
83    IF (K-M) 82,100,100
82    K=K+1
      GO TO 31
90    GO TO (91,92),NNUI
91    NNUI=2
      GO TO 120
92    SS=DK/DENOM
      SSQ=SS*SS
      STD = SS
      GO TO 120
100   GO TO (101,102),NBEI
101   DO 104 I=1,M
      DO 104 J=1,NP
      NJ=N+J
104   A(I,J)=X(I,NJ)
      GMDT=1.0D0
      NTHI=2
      K=K+1
      GO TO 110
102   GO TO 90
110   GO TO (111,112),NGAI
111   GO TO 90
112   DO 113 I=1,NP
      DO 113 J=1,NP
      SUM=0.0D0
      DO 114 L=1,M
114   SUM=SUM+A(L,I)*A(L,J)
      CV(J,I)=SUM
113   CV(I,J)=SUM
      DO 115 I=1,NP
115   CV(NP2,I)=SQRT(CV(I,I))
      NGAI=1
      DO 105 I=1,M
105   GMDT=GMDT*(GF(I)/ENF(I))
      GMDT=GMDT*GMDT
      GO TO 90
120   GO TO (121,122),NRHI
121   IF (NRBAR) 200,150,123
123   NRBAR=NRBAR-1
      NDEI=2
      NBEI=2
      NTHI=2
      NRHI=2
      GO TO (131,132),NZEI
131   DO 133 I=1,N
  133 X(M2,I)=Y(I)
      DO 134 I=1,NP
      NI=N+I
134   X(M2,NI)=0.0D0
      GO TO 32
132   DO 135 I=1,NPP
  135 X(M2,I)=Y(I)
      GO TO 32
122   GO TO (141,142),NSII
141   GO TO 121
142   DO 143 I=1,NP
      DO 143 J=I,NP
      VCV(I,J)=SSQ*CV(I,J)
  143 VCV(J,I)=VCV(I,J)
      DO 144 I=1,NP
  144 VCV(NP2,I)=SS*CV(NP2,I)
      DO 4444 I=1,NP
 4444 CS(I) = VCV(NP2,I)
      GO TO 121
200   CHECK=-1.0
      RETURN
150   CHECK=1.0
      DO 4443 I = 1,NP
      DO 4443 J = I,NP
      CV(I,J) = VCV(I,J)/SQRT(VCV(I,I)*VCV(J,J))
 4443 CV(J,I) = CV(I,J)
      RETURN
      END
                        
                                       
      SUBROUTINE MATZ(X,I,J)
      DIMENSION X(I,J)
      DO 1101 II=1,I
      DO 1101 JJ=1,J
1101  X(II,JJ)=0.0
      RETURN
      END
                        
      SUBROUTINE PRINTMAT(X,IJ,II,CH,M)
      DIMENSION X(21,20),II(20)
      CHARACTER*5 CH(M)
      DO 3002 I=1,IJ
      K=II(I)
      IF(ABS(X(I,1)).GT.1.0001) THEN
      WRITE(26,6302) CH(K),(X(I,J),J=1,IJ)
      ELSE
      WRITE(26,6301) CH(K),(X(I,J),J=1,IJ)
      END IF
3002  CONTINUE
      RETURN
6301  FORMAT(' ',1A5,1X,20(F6.3,1X,:))
6302  FORMAT(' ',1A5,1X,20(E8.2,1X,:))
      END
                        
      SUBROUTINE ZPRINT(Z,M,N)
      DIMENSION Z(20,400)
      DO 4001 I=1,N
4001  WRITE(26,6401)(Z(J,I),J=1,M)
      RETURN
6401  FORMAT(' ',20(E12.6,1X,:))
      END



